/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.problem;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.pa.fedc.FEDCJavaExecutable;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.NativeProcess;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.io.FileWriter;
import java.io.InputStream;

public class CollectEED
implements Runnable,
FEDCJavaExecutable {
    private static final String TRACE_MASKT = "XPACOLET";
    private static final String TRACE_MASKF = "XPACOLEF";
    private static final String TRACE_MASKD = "XPACOLED";
    private static final String DEFAULT_EED_PATH = "eeddirectory";
    private String _parms = null;
    private Problem _problem;

    public CollectEED(String parms) {
        Trace.trace(TRACE_MASKT, "--> CollectEED.ctor (" + parms + ")");
        this._parms = parms;
    }

    public Problem getProblem() {
        Trace.trace(TRACE_MASKT, "<--> getProblem ");
        return this._problem;
    }

    public void setProblem(Problem problem) {
        Trace.trace(TRACE_MASKT, "--> setProblem ");
        this._problem = problem;
        Trace.trace(TRACE_MASKD, "the problem is " + problem.getUniqueKey());
        Trace.trace(TRACE_MASKT, "<-- setProblem ");
    }

    public void run() {
        Trace.trace(TRACE_MASKD, "running CollectEED with parm=" + this._parms);
        try {
            if (this._problem != null) {
                Trace.trace(TRACE_MASKD, "running for problem " + this._problem.getUniqueKey());
            } else {
                Trace.trace(TRACE_MASKD, "the problem wasn't set");
            }
            if (this._problem == null) {
                return;
            }
            CommonProblem theProblem = null;
            if (this.getProblem() instanceof CommonProblem) {
                Process pid;
                theProblem = (CommonProblem)this.getProblem();
                PASystem failingSystem = theProblem.getFailingSystem();
                String parms = null;
                if (failingSystem != null) {
                    parms = failingSystem.getMachineType() + "-" + failingSystem.getMachineModel() + "*" + failingSystem.getMachineSerial();
                    Trace.trace(TRACE_MASKD, "the parms are " + parms);
                }
                String outputDir = BaseFileControl.getFilePath(DEFAULT_EED_PATH);
                if (parms != null && outputDir != null && (pid = RootProcess.startProgram("newcollecteed -m " + parms + " -d " + outputDir)) != null) {
                    InputStream ips = pid.getInputStream();
                    int rc = pid.waitFor();
                    byte[] b = new byte[1255];
                    String buffer = "";
                    StringBuffer sb = new StringBuffer();
                    if (ips != null) {
                        int bytesRead = ips.read(b);
                        while (bytesRead > 0) {
                            sb.append(new String(b, 0, bytesRead, "US-ASCII"));
                            bytesRead = ips.read(b);
                        }
                        Trace.trace(TRACE_MASKD, "the output was");
                        Trace.trace(TRACE_MASKD, sb.toString());
                        FileWriter fw = new FileWriter(outputDir + "sys.eed");
                        fw.write(sb.toString());
                        fw.close();
                    }
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an error");
            Trace.trace(TRACE_MASKD, e);
        }
    }

    public static void main(String[] args) {
        try {
            Trace.trace(TRACE_MASKD, "running Collect EED");
            CollectEED me = new CollectEED("test parms");
            me.run();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
        }
    }

    private static int getExitStatus(NativeProcess np) {
        boolean done = false;
        int exitStatus = -1;
        while (!done) {
            try {
                exitStatus = np.waitFor();
                done = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        Trace.trace(TRACE_MASKF, "Exit status from root program = " + exitStatus);
        return exitStatus;
    }
}

